// MyPropertySheet.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "MyPropertySheet.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyPropertySheet

IMPLEMENT_DYNAMIC(CMyPropertySheet, CPropertySheet)

CMyPropertySheet::CMyPropertySheet(CWnd* pWndParent)
	  : CPropertySheet(IDS_PROPSHT_CAPTION, pWndParent)
{
	// Add all of the property pages here.  Note that
	// the order that they appear in here will be
	// the order they appear in on screen.  By default,
	// the first page of the set is the active one.
	// One way to make a different property page the 
	// active one is to call SetActivePage().

	AddPage(&m_Page1);
	AddPage(&m_Page2);
}

CMyPropertySheet::~CMyPropertySheet()
{
}


BEGIN_MESSAGE_MAP(CMyPropertySheet, CPropertySheet)
	//{{AFX_MSG_MAP(CMyPropertySheet)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMyPropertySheet message handlers

int CMyPropertySheet::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	//lpCreateStruct->style &= ~WS_CAPTION;
	
	if (CPropertySheet::OnCreate(lpCreateStruct) == -1)
		return -1;

	EnableStackedTabs(FALSE);
	
	return 0;
}

BOOL CMyPropertySheet::OnInitDialog() 
{
	BOOL bResult = CPropertySheet::OnInitDialog();
	
	// create the image list for the tab control
	m_imageTab.Create( IDB_TAB_IMAGES, 16, 1, RGB( 0, 128, 128 ));
	pTab = GetTabControl();
	pTab->SetImageList( &m_imageTab );

	// set the tab style to bottom
	pTab->ModifyStyle( 0, TCS_BOTTOM );

	// add icons to tabs
	TC_ITEM tcItem;
	tcItem.mask = TCIF_IMAGE;

	for( int i = 0; i < 2; i++ )
	{
		tcItem.iImage = i;
		pTab->SetItem( i, &tcItem );
	}

	return bResult;
}

BOOL CMyPropertySheet::PreCreateWindow(CREATESTRUCT& cs) 
{
	//cs.style &= ~WS_CAPTION;

	return CPropertySheet::PreCreateWindow(cs);
}
